unit Planets;

interface
uses Satelits;

type
 TptPlanets = ^TPlanets;
 TPlanets   = record
 Name     : string[32];   //  
 Mass     : double;       //  ()
 Diam     : double;       //  (.)
 Dens     : double;       //  (/c3)
 Tmax     : double;       // .  (C)
 Tmin     : double;       // .  (C)
 Day      : double;       //   (  )
 Orbit    : double;       //    C (..)
 Period   : double;       //     ( )
 SatNum   : integer;      // - 
 ptSat    : TptSatArr;    //    
 FName    : string;       //   
end;

const SolarSystem : array [0..10] of TPlanets =
(
// --------------------------
(Name  : '';
Mass   : 3.3E23;
Diam   : 4.87;
Dens   : 5.43;
Tmax   : 480;
Tmin   : - 180;
Day    : 58.65;
Orbit  : 0.387;
Period : 0.24;
SatNum : 0;
ptSat  : nil;
FName  : '-200-200.bmp'),
// --------------------------
(Name  : '';
Mass   : 4.87E24;
Diam   : 12.1;
Dens   : 5.25;
Tmax   : 480;
Tmin   : 480;
Day    : 243;
Orbit  : 0.723;
Period : 0.62;
SatNum : 0;
ptSat  : nil;
FName  : '-200-200.bmp'),
// --------------------------
(Name  : '';
Mass   : 5.976E24;
Diam   : 12.756;
Dens   : 5.518;
Tmax   : 58;
Tmin   : - 90;
Day    : 1;
Orbit  : 1;
Period : 1;
SatNum : 1;
ptSat  : @SatEarth;
FName  : '-200-200.bmp'),
// --------------------------
(Name  : '';
Mass   : 6.4E23;
Diam   : 6.67;
Dens   : 3.95;
Tmax   : 0;
Tmin   : - 150;
Day    : 1.03;
Orbit  : 1.5237;
Period : 1.88;
SatNum : 2;
ptSat  : @SatMars;
FName  : '-200-200.bmp'),
// --------------------------
(Name  : '';
Mass   : 1.9E27;
Diam   : 143.76;
Dens   : 1.31;
Tmax   : - 160;
Tmin   : - 160;
Day    : 0.41;
Orbit  : 5.2;
Period : 11.86;
SatNum : 63;
ptSat  : @SatJupiter;
FName  : '-200-200.bmp'),
// --------------------------
(Name  : '';
Mass   : 5.68E26;
Diam   : 120.42;
Dens   : 0.71;
Tmax   : - 150;
Tmin   : - 150;
Day    : 0.44;
Orbit  : 9.54;
Period : 29.46;
SatNum : 62;
ptSat  : @SatSaturn;
FName  : '-200-200.bmp'),
// --------------------------
(Name  : '';
Mass   : 8.7E25;
Diam   : 51.3;
Dens   : 1.27;
Tmax   : - 220;
Tmin   : - 220;
Day    : 0.72;
Orbit  : 19.2;
Period : 84;
SatNum : 27;
ptSat  : @SatUranus;
FName  : '-200-200.bmp'),
// --------------------------
(Name  : '';
Mass   : 1E26;
Diam   : 49.5;
Dens   : 1.77;
Tmax   : - 213;
Tmin   : - 213;
Day    : 0.74;
Orbit  : 30;
Period : 165;
SatNum : 13;
ptSat  : @SatNeptun;
FName  : '-200-200.bmp'),
// --------------------------
(Name  : '  (. )';
Mass   : 1.3E22;
Diam   : 2.32;
Dens   : 2;
Tmax   : - 230;
Tmin   : - 230;
Day    : 6.4;
Orbit  : 39.4;
Period : 247.7;
SatNum : 3;
ptSat  : @SatPluton;
FName  : '-200-200.bmp'),
// --------------------------
(Name  : ' (. )';
Mass   : 0.4E22;
Diam   : 1.4;
Dens   : 3;
Tmax   : - 230;
Tmin   : - 230;
Day    : 0.16;
Orbit  : 43.3;
Period : 285;
SatNum : 2;
ptSat  : @SatHaumea;
FName  : '-200-200.bmp'),
// --------------------------
(Name  : '   (. )';
Mass   : 1.67E22;
Diam   : 2.4;
Dens   : 2.5;
Tmax   : - 230;
Tmin   : - 230;
Day    : 0.25;
Orbit  : 67.9;
Period : 557;
SatNum : 1;
ptSat  : @SatEris;
FName  : '-200-200.bmp')
// --------------------------
);

const ptSolarSystem : array [0..10] of TptPlanets =
(
  @SolarSystem[0],
  @SolarSystem[1],
  @SolarSystem[2],
  @SolarSystem[3],
  @SolarSystem[4],
  @SolarSystem[5],
  @SolarSystem[6],
  @SolarSystem[7],
  @SolarSystem[8],
  @SolarSystem[9],
  @SolarSystem[10]
);

implementation
end.
